function error = mispricing_CDS_x0(x0, cds, discounts, discounts_inbetween, maturity, start_date_num, end_date_num, liq_prem_cds, ajd_common, y0)
% --------------------------------------------------------------------------------------------------
% Wrapper function that calculates the (absolute) pricing error for a credit default swap. The first
% argument overwrites the initial default intensity in the definition of the CDS in order to be able
% to apply Newton-Raphson to this function.
% --------------------------------------------------------------------------------------------------
% x0                    ... initial default intensity
% cds                   ... structure containing credit default swap time series (see 'all_steps_in_a_row.m')
% discounts             ... discount curve (quarterly frequency, end of period)
% discounts_inbetween   ... discount curve (quarterly frequency, middle of period)
% maturity              ... for which maturity to calculate mispricing, default: 5yr
% liq_prem_cds          ... (time series of) liquidity premium for CDS vs. index, i.e. excess discount rate
% ajd_common            ... dynamics of common factor
% y0                    ... initial value(s) of common factor
% --------------------------------------------------------------------------------------------------
% sample call: mispricing_CDS_x0([0.01; 0.03], cds_test, exp(-0.05*repmat(0.25:0.25:5.25, 2, 1)), exp(-0.05*repmat((0.25:0.25:5.25)-1/8, 2, 1)), 1)
% --------------------------------------------------------------------------------------------------

% Re-set initial default intensity (anchored to dates{1})
%[start_pos, end_pos] = used_range_c(cds.dates{1}, start_date_num, end_date_num);
start_pos = find(cds.dates{1} >= start_date_num, 1, 'first');
end_pos = find(cds.dates{1} <= end_date_num, 1, 'last');
used_range = start_pos:end_pos;
cds.x0(used_range,1) = x0;

% Calculate risk-neutral survival and default probability for each (future) coupon payment date
maturities = (1:length(cds.dates)) == maturity;
default_probs = default_probs_cds2(cds, maturities, start_date_num, end_date_num, ajd_common, y0);

% Calculate model-implied mispricing
error = value_fixed_leg_CDS(cds.dates{maturity}(used_range), cds.T{maturity}(used_range), cds.market_price{maturity}(used_range), ...
                            cds.LGD, discounts, discounts_inbetween, default_probs, liq_prem_cds) - ...
        value_default_leg_CDS(cds.dates{maturity}(used_range), cds.T{maturity}(used_range), cds.market_price{maturity}(used_range), ...
                              cds.LGD, discounts, discounts_inbetween, default_probs);
error = abs(error);